
# #OpTanzania — OSINT Collection Starter Kit

**Purpose:** Collect, verify, and archive public information related to events in Tanzania, with an emphasis on **network disruptions**, **official statements**, and **publicly shared media**. This kit is designed for lawful OSINT and documentation work. Use responsibly.

## Quick Start

1. **Create and edit config:**  
   ```bash
   cp config.sample.yaml config.yaml
   nano config.yaml
   ```

2. **Install requirements (Python 3.10+):**  
   ```bash
   python -m venv .venv && source .venv/bin/activate
   pip install -r requirements.txt
   ```

3. **Run the collectors:**  
   - News/RSS + basic site scraping:
     ```bash
     python scripts/scraper.py --mode news
     ```
   - Social (X/Twitter via API v2, optional):
     ```bash
     python scripts/scraper.py --mode social --since 2025-10-25
     ```
   - Blackout monitors (NetBlocks/OONI snapshots):
     ```bash
     python scripts/scraper.py --mode blackouts
     ```

4. **Verify media (EXIF + video probe + hashes):**
   ```bash
   python scripts/verifier.py --in raw_data/video --out processed/verified_media
   ```

5. **Archive to Wayback/Archive.Today (where allowed):**
   ```bash
   python scripts/archiver.py --path raw_data --concurrency 3
   ```

6. **Generate daily digest (HTML/PDF skeleton):**
   ```bash
   python scripts/digest_builder.py --date 2025-10-31
   ```

## Ethics & Safety

- Do **not** dox or target private persons.  
- Redact faces and exact locations of civilians before publishing.  
- Respect platform Terms of Service and local laws.  
- Prefer official APIs; rate-limit scrapers; store provenance (URLs, timestamps, hashes).

---

## Structure

```
OpTanzania/
├── config.sample.yaml
├── README.md
├── requirements.txt
├── raw_data/
│   ├── news/
│   ├── social/
│   ├── video/
│   └── blackouts/
├── processed/
│   ├── verified_media/
│   └── timeline_csv/
├── reports/
│   ├── daily_digest/
│   └── incident_maps/
└── scripts/
    ├── scraper.py
    ├── verifier.py
    ├── archiver.py
    └── digest_builder.py
```

## Notes

- **NetBlocks/OONI**: This kit polls their public status pages/feeds (where available). You may need to add API keys or adapt endpoints if rate-limited.  
- **X/Twitter**: Set your bearer token in `config.yaml`. If you don’t have API access, you can disable social collection.  
- **YouTube/TikTok**: Uses `yt-dlp` for metadata and media download. Install system ffmpeg for best results.
